﻿<%@ Page Language="c#" CodePage="1200" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Import Namespace="Soneta.CRM" %>
<%@ Import Namespace="Soneta.Tools" %>
<%@ import Namespace="Soneta.Core" %>
<%@ import Namespace="Soneta.Business" %>
<%@ import Namespace="Soneta.Business.App" %>
<%@ import Namespace="Soneta.Kasa" %>
<%@ import Namespace="Soneta.Types" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<title>Rozliczenie delegacji</title>
		<script runat="server">

            class Total {
                   readonly string opis;
                   readonly decimal kwota;
                   public Total(string opis, decimal kwota) {
                       this.opis = opis;
                       this.kwota = kwota;
                   }
                   public string Opis {
                       get { return opis; }
                   }
                   public decimal Kwota {
                       get { return kwota; }
                   }
            }
    
            class ComparePSP: IComparer {
        
			    public int Compare(object x, object y) {
			        KompensataPozycja px = (KompensataPozycja)x;
			        KompensataPozycja py = (KompensataPozycja)y;
			    
			        if (px==null && py==null)
					    return 0;
				    if (px==null)
					    return -1;
				    if (py==null)
					    return 1;
					
				    int i = px.DataDokumentu.CompareTo(py.DataDokumentu);
				    if (i==0)
				        i = px.NumerDokumentu.CompareTo(py.NumerDokumentu);
				    return i;				
			    }
            }

            ArrayList zaliczki = new ArrayList();
            ArrayList zobowiązania = new ArrayList();

		    void OnContextLoad(Object sender, EventArgs args)
		    {
		        RozliczenieDelegacji doc = (RozliczenieDelegacji) dc[typeof (RozliczenieDelegacji)];
		        if (doc.NumerDruku != "")
		            ReportHeader1["DRUK"] = "|</strong>Numer druku: <strong>" + doc.NumerDruku;
		        else
		            ReportHeader1["DRUK"] = "";
		        foreach (KompensataPozycja p in doc.Pozycje)
		            if (p.Należność > Currency.Zero)
		                zaliczki.Add(p);
		            else
		                zobowiązania.Add(p);

		        zaliczki.Sort(new ComparePSP());
		        zobowiązania.Sort(new ComparePSP());

		        Grid1.DataSource = zaliczki;
		        Grid2.DataSource = zobowiązania;
		        Grid3.DataSource = new object[] {doc};
		        Grid4.DataSource = new object[]
		        {
		            new Total("Dojazdy", doc.RyczaltDojazdy.Value),
		            new Total("Diety", doc.Diety.Value),
		            new Total("Noclegi", doc.RyczaltNoclegi.Value)
		        };
		    }

		</script>
		<meta content="Microsoft Visual Studio 7.0" name="GENERATOR">
		<meta content="C#" name="CODE_LANGUAGE">
		<meta content="JavaScript" name="vs_defaultClientScript">
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</HEAD>
	<body>
		<form id="RozliczenieDelegacji" method="post" runat="server">
			<ea:datacontext id="dc" runat="server" oncontextload="OnContextLoad" TypeName="Soneta.Kasa.RozliczenieDelegacji,Soneta.Kasa"></ea:datacontext>
			<cc1:ReportHeader id="ReportHeader1" title="Rozliczenie delegacji|</strong>Numer: <strong>{0}%DRUK%|</strong>Data: <strong>{1}|</strong>Waluta: <strong>{2}"
				runat="server" DataMember1="Data" DataMember0="Numer" DataMember2="Należność.Symbol"></cc1:ReportHeader>
			<p>
				<em>Kontrahent:</em><br/>
				<ea:DataLabel id="DataLabel1" runat="server" DataMember="Podmiot.NazwaFormatowana" EncodeHTML="True"></ea:DataLabel><br>
				<ea:DataLabel id="DataLabel2" runat="server" DataMember="Podmiot.Adres.Linia1" EncodeHTML="True"></ea:DataLabel><br>
				<ea:DataLabel id="DataLabel3" runat="server" DataMember="Podmiot.Adres.Linia2" EncodeHTML="True"></ea:DataLabel>
			</p>
			<p>
				<em>Rozliczone zaliczki:</em>
				<ea:DataLabel id="DataLabel14" runat="server" DataMember="RazemZaliczki" Format="{0:n}" EncodeHTML="True"></ea:DataLabel><BR>
				<ea:Grid id="Grid1" runat="server" DataMember="Pozycje" RowTypeName="Soneta.Kasa.KompensataPozycja,Soneta.Kasa">
					<Columns>
						<ea:GridColumn Width="34" DataMember="NumerDokumentu" Caption="Dokument" NoWrap="True" EncodeHTML="True" runat="server"></ea:GridColumn>
						<ea:GridColumn EncodeHTML="True" runat="server" Caption="Opis" DataMember="Opis" NoWrap="True"></ea:GridColumn>
						<ea:GridColumn Width="10" Align="Center" DataMember="DataDokumentu" Total="Info" Caption="Data" EncodeHTML="True" runat="server"></ea:GridColumn>
						<ea:GridColumn Width="15" Align="Right" DataMember="Należność" Total="Sum" Caption="Kwota" Format="{0:n}" EncodeHTML="True" runat="server"></ea:GridColumn>
					</Columns>
				</ea:Grid>
			</p>
			<p>
				<em>Rozliczone dokumenty: </em>
				<ea:DataLabel id="DataLabel13" runat="server" DataMember="RazemDokumenty" Format="{0:n}" EncodeHTML="True"></ea:DataLabel><BR>
				<ea:Grid id="Grid2" runat="server" DataMember="Pozycje" RowTypeName="Soneta.Kasa.KompensataPozycja,Soneta.Kasa">
					<Columns>
						<ea:GridColumn Width="18" DataMember="NumerDokumentu" Caption="Dokument" NoWrap="True" EncodeHTML="True" runat="server"></ea:GridColumn>
						<ea:GridColumn Width="16" DataMember="NumerEwidencji" Caption="Ewidencja" NoWrap="True" EncodeHTML="True" runat="server"></ea:GridColumn>
						<ea:GridColumn DataMember="DokRozliczany.Podmiot.Nazwa" Caption="Podmiot" EncodeHTML="True" runat="server"></ea:GridColumn>
						<ea:GridColumn Width="32" DataMember="Opis" Caption="Opis" NoWrap="True" EncodeHTML="True" runat="server"></ea:GridColumn>
						<ea:GridColumn Width="10" Align="Center" DataMember="DataDokumentu" Total="Info" Caption="Data" EncodeHTML="True" runat="server"></ea:GridColumn>
						<ea:GridColumn Width="15" Align="Right" DataMember="Zobowiązanie" Total="Sum" Caption="Kwota" Format="{0:n}" EncodeHTML="True" runat="server"></ea:GridColumn>
					</Columns>
				</ea:Grid>
			</p>
			<p>
				<table id="Table1" cellspacing="0" width="100%">
					<tbody>
						<tr>
							<td valign="top" width="50%">
								<em>Diety i ryczałty:</em>
								<ea:DataLabel id="DataLabel12" runat="server" DataMember="RazemRyczalty" Format="{0:n}" EncodeHTML="True"></ea:DataLabel>
								<ea:Grid id="Grid4" runat="server">
									<Columns>
										<ea:GridColumn Width="12" DataMember="Opis" Total="Info" EncodeHTML="True" runat="server"></ea:GridColumn>
										<ea:GridColumn Width="12" Align="Right" DataMember="Kwota" Total="Sum" Format="{0:n}" EncodeHTML="True" runat="server"></ea:GridColumn>
									</Columns>
								</ea:Grid>
							</td>
							<td valign="top">
								<p>
									<em>Pozostaje:</em>
									<ea:Grid id="Grid3" runat="server">
										<Columns>
											<ea:GridColumn Width="12" Align="Right" DataMember="Należność" Caption="Należności" Format="{0:n}" EncodeHTML="True" runat="server"></ea:GridColumn>
											<ea:GridColumn Width="12" Align="Right" DataMember="Zobowiązanie" Caption="Zobowiązania" Format="{0:n}" EncodeHTML="True" runat="server"></ea:GridColumn>
										</Columns>
									</ea:Grid>
								</p>
							</td>
						</tr>
					</tbody>
				</table>
			</p>
			<ea:DataLabel id="DataLabel7" runat="server" DataMember="Opis" Bold="False" EncodeHTML="True"></ea:DataLabel>
			<cc1:ReportFooter id="ReportFooter1" runat="server" TheEnd="False" Height="105px">
				<Subtitles>
					<cc1:FooterSubtitle SubtitleType="Operator" Width="50"></cc1:FooterSubtitle>
					<cc1:FooterSubtitle Caption="Data i podpis" Width="50"></cc1:FooterSubtitle>
				</Subtitles>
			</cc1:ReportFooter>
		</form>
	</body>
</HTML>

